<?php 
   /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "gUtil/DbManager.php";
    include "include/costanti.php";
    include "include/util.php";
    include "template/stile.php";
    include "template/funzioni.php";

    session_start();
    if(!isset($_SESSION["geecomUser_email"])) {
            header("Location: ../index.php");
    }
    else {
        $geecomDb = new DbManager($costantiDatabase);		

        $tipo = $geecomDb->escapeString($_GET["tipo"]);
        $impostazioni = recuperaImpostazioni($geecomDb);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title><?php echo($opzioniSis["nomePiattaforma"]); ?> - crea segnalazione </title>


    <?php 
	include "include/includeCssBase.php"; 
    ?>
    <!-- Stile utente personalizzato -->
    <link rel="stylesheet" type="text/css" href="template/stile.css">
        
    <link href="../template/css/multiple-select.css" rel="stylesheet" />
</head>

<body>
<div id="wrap">
    
      <!-- barra superiore -->
	<?php 
            include "template/include/menuPrincipale.php";  
        ?>
    <!-- /barra superiore -->
    <header></header>
    <!-- riga menu secondario -->
    <section id="menuSecondario">
        <!-- contenuto principale -->
        <div id="contenutoPrincipale" class="row">
        <?php
                    if(isset($_GET["status"])) {
                            if($_GET["status"]==5) {
                                    echo"<p class=\"alert alert-success\">Associazione rimossa, ora si può selezionare una nuova galleria</p>";
                            }
                    }
            ?>
            <!-- 
                 questo div serve solo per centrare la colonna, è visibile solo sugli schermi
                 md e lg
            -->
            <div id="colonnaSinistra" class="col-md-2 hidden-xs hidden-sm"></div>
        <!-- prima colonna -->
        <div id="colonnaPrincipale" class="col-lg-8 col-md-8 col-sm-12 col-xs-12">

            <h1>Crea una nuova segnalazione</h1>

            <!-- form -->
            <form class="form-horizontal" role="form" name="formCreaArticolo" action="comunicazioni/creaSegnalazione.php" method="post" >
                        <div class="form-group">
                <label for="campoTesto1" class="col-sm-3 control-label">Oggetto</label>
                <div class="col-sm-9">
                  <input type="text" class="form-control" id="oggettoComunicazione" name="oggetto" placeholder="Oggetto della segnalazione" required>
                </div>
              </div>

              <div class="form-group">
                <label for="selectEsempio1"class="col-sm-3 control-label">Seleziona i gruppi </label>
                 <div class="col-sm-5">
                       <select name="idGruppi[]" id="idGruppo" multiple="multiple">
                       <?php 
                            $queryGruppi = "SELECT * FROM geecAd_gruppiUtenti AS gu JOIN geecAd_gruppi AS g ON g.id = gu.idGruppo WHERE gu.idUtente = {$_SESSION["geecomUser_id"]}";
                            $risGruppi = $geecomDb->eseguiQueryLettura($queryGruppi);
                            while($gruppo = $risGruppi->fetch_assoc()) {
                                    echo"<option value=\"{$gruppo["id"]}\">{$gruppo["nomeGruppo"]}</option>";
                            }
                        ?>
                       </select>
                   </div>
               </div>

              <div class="form-group">
                <div class="col-sm-offset-1 col-sm-11">
                  <textarea class="form-control" rows="15" id="testoComunicazione" name="testo" placeholder="Inserisci qui il testo"></textarea>
                </div>
              </div>

              <div class="form-group">
                <div class="col-sm-offset-1 col-sm-9">
                  <button type="submit" class="btn btn-primary" >Invia</button>
                </div>
              </div>

          </div>

        </div>
        <!-- /prima colonna --> 

        <!-- seconda colonna --> 
        <div id="colonnaSecondaria" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
    <div class="panel-group" id="accordion">


    </div>    </div>
        <!-- /seconda colonna -->

        </div>
        <!-- /contenuto principale -->
    </section>  

    <?php
	include "template/include/footer.php";
    ?>
    
    <!-- Scroll to Top  -->
    <div class="scroll-top page-scroll visible-xs visible-sm">
        <a class="btn btn-primary" href="#top">
            <i class="fa fa-chevron-up"></i>
        </a>
    </div>
    
    <?php 
            include "include/includeJsBase.php";
    ?>
    
    <script src="js/jquery.multiple.select.js"></script>
    
    <?php 
            include "template/include/includeJsTemplate.php";
    ?>
    
    
	<!-- plugin multiple select -->
	<script>
	    $(function() {
		   $('#idGruppo').change(function() {
		       console.log($(this).val());
		   }).multipleSelect({
		       width: '100%'
		   });
	    });
	</script>
	
	<!-- Editor articolo -->
	<script type="text/javascript" src="js/tinymce/tinymce.min.js"></script>
	<script type="text/javascript">
	tinymce.init({
	    selector: "textarea",
            branding: false,
	    plugins: "textcolor link jbimages media code",
    	    toolbar: "undo redo bold italic link unlink alignleft aligncenter alignright alignjustify bullist numlist forecolor backcolor jbimages media code",
	    language : 'it'
	 });
	</script>
</body>
</html>
<?php 
	}